<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include 'db.php';  // Include database connection

// Fetch data from loginusers instead of liveaccounts
$sql = "SELECT * FROM loginusers ORDER BY id DESC";
$result = $conn->query($sql);

$clients = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        // Map the fields to match your React table columns
        $clients[] = [
            "id" => $row['id'],
            "trade_id" => "N/A", // No trade_id in loginusers, you can leave blank or generate dynamically
            "account_name" => $row['first_name'] . ' ' . $row['last_name'],
            "email" => $row['email'],
            "phone_pwd" => $row['phone'], // rename phone field to match frontend
            "strategycountry" => $row['country'],
            "status" => "Enabled" // Default user status if not in table
        ];
    }
}

echo json_encode([
    "success" => true,
    "clients" => $clients
]);
?>
