<?php
include "config.php";

// Simple function to add random profit data
function updateAllProfits($conn) {
    // Get all active accounts
    $result = $conn->query("SELECT trade_id FROM liveaccounts WHERE status = 'active'");
    
    if ($result->num_rows === 0) {
        echo "No active accounts found!\n";
        return;
    }
    
    $updated = 0;
    while ($row = $result->fetch_assoc()) {
        // Generate random profit between -1000 and 2000
        $profit = round(rand(-1000, 2000) + rand(0, 99) / 100, 2);
        
        $stmt = $conn->prepare("
            INSERT INTO account_profits (trade_id, total_profit, last_updated) 
            VALUES (?, ?, NOW())
            ON DUPLICATE KEY UPDATE 
            total_profit = VALUES(total_profit), 
            last_updated = NOW()
        ");
        $stmt->bind_param("sd", $row['trade_id'], $profit);
        
        if ($stmt->execute()) {
            echo "Updated account {$row['trade_id']}: $$profit\n";
            $updated++;
        } else {
            echo "Error updating account {$row['trade_id']}: " . $conn->error . "\n";
        }
    }
    
    echo "Successfully updated $updated accounts!\n";
}

// Run the update
updateAllProfits($conn);
?>